/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.usbdm.connections.usbdm;

import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Text;

class HexTextAdapter {
    Text textField;
    String formatString = "%X";

    Text getObject() {
        return this.textField;
    }

    HexTextAdapter(Text textField) {
        this.textField = textField;
        textField.setTextLimit(4);
        textField.addVerifyListener((VerifyListener)new HexVerifyListener());
    }

    HexTextAdapter(Text textField, int width) {
        this.textField = textField;
        textField.setTextLimit(width);
        textField.addVerifyListener((VerifyListener)new HexVerifyListener());
    }

    public int getHexValue() {
        int value = 0;
        try {
            value = Integer.parseInt(this.textField.getText(), 16);
        }
        catch (NumberFormatException numberFormatException) {}
        return value;
    }

    public void setHexValue(int value) {
        if (value == 0) {
            this.textField.setText("default");
        }
        this.textField.setText(String.format(this.formatString, value));
    }

    private class HexVerifyListener
    implements VerifyListener {
        private HexVerifyListener() {
        }

        public void verifyText(VerifyEvent e) {
            String string = e.text = e.text.toUpperCase();
            char[] chars = new char[string.length()];
            string.getChars(0, chars.length, chars, 0);
            int i = 0;
            while (i < chars.length) {
                if (!('0' <= chars[i] && chars[i] <= '9' || 'A' <= chars[i] && chars[i] <= 'F')) {
                    e.doit = false;
                    return;
                }
                ++i;
            }
        }
    }
}

